# Laitoxx Multi-Tool V2.2.1

<img width="1914" height="997" alt="Снимок экрана 2025-08-31 123509" src="https://github.com/user-attachments/assets/8063d5ee-b8a3-417b-a1aa-d81471ed79b6" />


---

### 📌 English

Laitoxx is a powerful OSINT (Open-Source Intelligence) and cybersecurity toolkit, now completely rebuilt with a modern, user-friendly Graphical User Interface (GUI). It is designed for educational and research purposes, helping users to collect publicly available data for security analysis, penetration testing, and digital footprint assessment.

⚠ **Disclaimer**: This tool is created for educational purposes only. The developers are not responsible for any misuse of this software.

### ✨ What's New

*   **Complete GUI Overhaul**: The old console-based menu has been replaced with an intuitive and modern graphical interface.
*   **Plugin System**: Laitoxx is now extensible! You can add new functionality by creating or installing plugins without altering the core code.
*   **Theming Engine**: Customize the application's appearance with easy-to-edit `.json` theme files.
*   **Multi-Language Support**: The new architecture includes support for internationalization (i18n) to make the tool accessible to a global audience.
*   **Modular Architecture**: The entire codebase has been refactored into a clean, modular structure, making it easier to maintain and scale.

### 🔹 Features

*   **Modern GUI**: An intuitive and easy-to-use graphical interface.
*   **Extensible via Plugins**: Add new tools and features seamlessly.
*   **Customizable Themes**: Personalize your workspace with different color schemes.
*   **Comprehensive OSINT Tools**:
    *   Phone number lookup
    *   IP address tracking & scanning
    *   Email validation & OSINT
    *   Telegram OSINT
    *   Username search across social networks
*   **Web & Network Security Tools**:
    *   SQL vulnerability scanner
    *   Admin panel finder
    *   Port scanning
    *   Subdomain finder
    *   Web crawler
*   **Utilities**:
    *   Local database search
    *   Password generator
    *   Python code obfuscator
    *   And much more...

### 🚀 Installation & Usage

1.  **Clone the repository:**
    ```sh
    git clone https://github.com/Laitoxx/Laitoxx-Multi-Tool.git
    ```
2.  **Navigate to the project directory:**
    ```sh
    cd Laitoxx-Multi-Tool
    ```
3.  **Install dependencies:**
    ```sh
    pip install -r requirements.txt
    ```
4.  **Run the application:**
    ```sh
    python laitoxx.py
    ```

📌 **Audience**: For cybersecurity researchers, ethical hackers, and OSINT specialists.

---

### 📌 Русский

Laitoxx — это мощный инструмент для OSINT (разведки по открытым источникам) и кибербезопасности, полностью переработанный и оснащенный современным и удобным графическим интерфейсом (GUI). Он предназначен для образовательных и исследовательских целей и помогает пользователям собирать публичные данные для анализа безопасности, тестирования на проникновение и оценки цифрового следа.

⚠ **Дисклеймер**: Этот инструмент создан исключительно в образовательных целях. Разработчики не несут ответственности за его неправильное использование.

### ✨ Что нового

*   **Полностью новый GUI**: Старое консольное меню было заменено интуитивно понятным и современным графическим интерфейсом.
*   **Система плагинов**: Теперь Laitoxx можно расширять! Вы можете добавлять новую функциональность, создавая или устанавливая плагины, не изменяя основной код.
*   **Система тем**: Настраивайте внешний вид приложения с помощью легко редактируемых файлов тем в формате `.json`.
*   **Поддержка нескольких языков**: Новая архитектура включает поддержку интернационализации (i18n), чтобы сделать инструмент доступным для глобальной аудитории.
*   **Модульная архитектура**: Вся кодовая база была реорганизована в чистую, модульную структуру, что упрощает ее поддержку и масштабирование.

### 🔹 Функционал

*   **Современный GUI**: Интуитивно понятный и простой в использовании графический интерфейс.
*   **Расширяемость через плагины**: Легко добавляйте новые инструменты и функции.
*   **Настраиваемые темы**: Персонализируйте свое рабочее пространство с помощью различных цветовых схем.
*   **Комплексные инструменты OSINT**:
    *   Поиск информации по номеру телефона
    *   Отслеживание и сканирование IP-адресов
    *   Валидация и OSINT по email
    *   Telegram OSINT
    *   Поиск по никнейму в социальных сетях
*   **Инструменты для веб-безопасности и сетей**:
    *   Сканер SQL-уязвимостей
    *   Поиск административных панелей
    *   Сканирование портов
    *   Поиск субдоменов
    *   Веб-краулер
*   **Утилиты**:
    *   Поиск по локальным базам данных
    *   Генератор паролей
    *   Обфускатор Python-кода
    *   И многое другое...

### 🚀 Установка и запуск

1.  **Клонируйте репозиторий:**
    ```sh
    git clone https://github.com/Laitoxx/Laitoxx-Multi-Tool.git
    ```
2.  **Перейдите в папку проекта:**
    ```sh
    cd Laitoxx-Multi-Tool
    ```
3.  **Установите зависимости:**
    ```sh
    pip install -r requirements.txt
    ```
4.  **Запустите приложение:**
    ```sh
    python laitoxx.py
    ```

📌 **Аудитория**: Для исследователей в области кибербезопасности, этичных хакеров и специалистов по OSINT.
